              
/*****************************************************************************
*                           Freescale Semiconductor                          *
*                   Brazilian Semiconductor Tecnology Center                 *
*                                                                            *
*  Project    : MC56F8006 Modular Pixel Matrix                               *
*  Version    : 0.1                                                          *
*  Date       : 16/Apr/2009                                                  *
*  Engineers  : Alexandre Dias, Bruno Bastos                                 *
*               Humberto Carvalho, Leonardo Mangiapelo                       *
*               Renato Frias                                                 *
*                                                                            *
* -------------------------------------------------------------------------- *
*  Description:                                                              *
*                                                                            *
*    MC56F8006 SCI															 * 
*                                                                            *
******************************************************************************/

/************************* Project Include Files *****************************/

#ifndef _LIB_SCI_H
#define _LIB_SCI_H

#include "mc56f8006.h"

/********************************* Defines ***********************************/

#define BSP_OSCILLATOR_FREQ 		8000000L
#define PLL_MUL                     1L
#define PLL_POSTSCALER				(1<<0)	/* 1,2,4,8,16,32 */
#define SCI_CLOCK_HZ				(BSP_OSCILLATOR_FREQ * PLL_MUL / PLL_POSTSCALER / 2 )
#define PrintDigit(d)				TERMIO_PrintDigit(d)
#define Print(s)					TERMIO_Print((int8_t*)s)
#define PrintInfo2(s1,s2)			Print((int8_t*)s1);	Print((int8_t*)" : "); Print((int8_t*)s2);Print((int8_t*)"\r\n")
#define PrintErr2(s1,s2)			Print((int8_t*)"Error: "); PrintInfo2(s1,s2)

/****************************** Prototypes ***********************************/

void TERMIO_PutChar(int8_t send); 
int8_t TERMIO_GetChar(void); 
void TERMIO_Print(int8_t * str );
void TERMIO_PrintDigit(uint16_t number) ;
void TERMIO_Init(uint32_t baudrate);
extern void TERMIO_Print(int8_t *str);

#endif